package gui.menus.edit;

import gui.MainFrame;
import gui.GenericLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import java.io.*;
import java.util.Properties;
//import java.util.Vector;

import service.*;

/**
 * @author Andrea
 *
 */
public class setTargetServItem extends JMenuItem 
{
	static final long serialVersionUID = 1l;
	public setTargetServItem()
	{
		super();
		initialize();
	}
	
	private void initialize()
	{
		this.setText("Set Target System...");
		
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				if(GenericLoader.orchestratorIsStarted()){
					JOptionPane.showMessageDialog(MainFrame.getInstance(), "You have to stop the orchestrator, first", "Action not allowed", JOptionPane.WARNING_MESSAGE);
					return;
				}
				JFileChooser jfc = new JFileChooser();
				FileInputStream in;
				try {
					Properties applicationProps=new Properties();
					in = new FileInputStream("symphony.conf");
					applicationProps.load(in);
					jfc=new JFileChooser(applicationProps.getProperty("targetDirectory"));
					//System.out.println(applicationProps);
					in.close();
				} catch (Exception e1) {
					
				}
				
				int returnVal = jfc.showDialog(MainFrame.getInstance(),"Set as Target Service");
				
				if(returnVal == JFileChooser.APPROVE_OPTION)
				{
					try
					{
						File file = jfc.getSelectedFile();
						try {
							Properties applicationProps=new Properties();

							in = new FileInputStream("symphony.conf");
							applicationProps.load(in);
							in.close();

							applicationProps.setProperty("targetDirectory", file.getParent());
	
							FileOutputStream out;
							try {
								out = new FileOutputStream("symphony.conf");
								applicationProps.store(out, "");
								out.close();
							} catch (FileNotFoundException e1) {
								e1.printStackTrace();
							} catch (IOException e2) {
								e2.printStackTrace();
							}			

						} catch (Exception e1) {
							
						}

						ServiceFactory servFact = new ServiceFactoryImpl();
						TransitionSystem<SimpleState, SimpleTransition> target = servFact.createSimpleTransitionSystem(file.getCanonicalPath());
						
						GenericLoader.setTargetService(target);
						GenericLoader.setTargetServiceName(file.getName());
						GenericLoader.setTargetServicePath(file.getAbsolutePath());
						MainFrame.getInstance().showTarget();
						
						JTable serviceList=MainFrame.getInstance().getAvServPanel().getTargetServiceList();
						String data[][]=new String[1][3];
							data[0][0]=target.getName();
							data[0][1]="none";
							data[0][2]=file.getName();
						TableModel tableModel = 
							new DefaultTableModel(
									data,
									new String[] { "TS name", "State","Filename"});
						serviceList.setModel(tableModel);
						serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
						serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
						serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);

						JOptionPane.showMessageDialog(MainFrame.getInstance(), "Target Transition System loaded");
						MainFrame.getInstance().getAvServPanel().getActionButton1().setEnabled(true);
						
					
					}
					catch(Exception exc)
					{
					JOptionPane.showMessageDialog(null, "Target system not loaded\nError: "+exc.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
					}
				}
			}
		});
	}

}
